#!/bin/bash

# Check whether certificate is already installed
security verify-cert -c "$1" -p ssl -L
return_value=$?

# If return code is different from 0, certificate is not (well) installed
if [ $return_value -ne 0 ]
then
  # Add certificate to current user's keychain
  security add-certificate "$1"
  return_value=$?
  if [ $return_value -ne 0 ]
  then
    # Early exit
    exit $return_value
  fi
  
  # Ensure it is trusted for SSL
  security add-trusted-cert -p ssl "$1"
  return_value=$?
  if [ $return_value -ne 0 ]
  then
    # Early exit
    exit $return_value
  fi
fi

# Exit with normal termination status code
exit 0

